<?php

declare(strict_types=1);

namespace Erlage\Photogram\Requests\Admin;

use Erlage\Photogram\Helpers\TraitFeedHelper;
use Erlage\Photogram\Data\Models\User\UserModel;
use Erlage\Photogram\Data\Tables\User\UserTable;
use Erlage\Photogram\Pattern\ExceptionalRequests;
use Erlage\Photogram\Data\Tables\Sys\RequestTable;
use Erlage\Photogram\Requests\User\UserFieldEditor;

final class AdminActions extends ExceptionalRequests
{
    use TraitFeedHelper;

    public static function saveUser(): void
    {
        self::$flagAdminMode = true;

        self::process(function ()
        {
            /*
            |--------------------------------------------------------------------------
            | get data from request
            |--------------------------------------------------------------------------
            */

            $userIdFromReq = self::$request -> findKey(
                UserTable::ID,
                RequestTable::PAYLOAD,
                UserTable::TABLE_NAME
            );

            self::ensureValue($userIdFromReq);

            /*
            |--------------------------------------------------------------------------
            | get target user
            |--------------------------------------------------------------------------
            */

            $targetUserModel = UserModel::findFromId_throwException($userIdFromReq);

            /*
            |--------------------------------------------------------------------------
            | login as user
            |--------------------------------------------------------------------------
            */

            self::$userSession -> loginAs($targetUserModel);

            self::userAuthenticate();

            /*
            |--------------------------------------------------------------------------
            | check and update available attributes
            |--------------------------------------------------------------------------
            */

            $attributesToCheck = array(
                UserTable::USERNAME,
                UserTable::EMAIL,
                UserTable::DISPLAY_NAME,
                UserTable::DISPLAY_WEB,
                UserTable::DISPLAY_BIO,
            );

            foreach ($attributesToCheck as $attribute)
            {
                $attributeValueFromReq = self::$request -> findKey(
                    $attribute,
                    RequestTable::PAYLOAD,
                    UserTable::TABLE_NAME
                );

                if (self::isAvailable($attributeValueFromReq))
                {
                    UserFieldEditor::internalFieldEditor($attribute);
                }
            }

            /*
            |--------------------------------------------------------------------------
            | return updated user' map
            |--------------------------------------------------------------------------
            */

            self::addToResponse(UserTable::getTableName(), self::$authedUserModel -> getDataMap());
        });
    }
}
